//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "FormMainWindow.h"
#include "About.h"
#include "stdio.h"
#include "io.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "cgrid"
#pragma resource "*.dfm"
TformMain *formMain;
//---------------------------------------------------------------------------
__fastcall TformMain::TformMain(TComponent* Owner)
    : TForm(Owner)
{
  formMain->Caption = titleText;
  formMain->Caption = formMain->Caption + " - Untitled";
  modified = false;
  mouseLeftButton = false;

  commColor[0]  = (TColor)clBlack;
  commColor[1]  = (TColor)clWhite;
  commColor[2]  = (TColor)0x004040E0;
  commColor[3]  = (TColor)0x00E1E160;
  commColor[4]  = (TColor)0x00E060E0;
  commColor[5]  = (TColor)0x0040E140;
  commColor[6]  = (TColor)0x00E14040;
  commColor[7]  = (TColor)0x0040E1E1;
  commColor[8]  = (TColor)0x0040A0E1;
  commColor[9]  = (TColor)0x0048749C;
  commColor[10] = (TColor)0x00A0A0FF;
  commColor[11] = (TColor)0x00545454;
  commColor[12] = (TColor)0x00888888;
  commColor[13] = (TColor)0x00A0FFA0;
  commColor[14] = (TColor)0x00FFA0A0;
  commColor[15] = (TColor)clSilver;

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
    {
      pixelColor[col][row] = 0;
      undoBuffer[col][row] = 0;
    }

  int left = 168;
  int top = 272;
  int colorNo = 0;
    for (int row=0; row<=3; row++)
    {
      colorSample[row] = new TShape(formMain);
      colorSample[row]->Parent=formMain;
      colorSample[row]->Left=left;
      colorSample[row]->Top=top;
      colorSample[row]->Width=33;
      colorSample[row]->Height=25;
      colorSample[row]->Brush->Color = commColor[colorNo];
      colorSample[row]->OnMouseDown = colorSampleMouseDown;
      top += 24;
      colorNo++;
    }

  lastColor = 1;
  colorSample[1]->Pen->Width = 5;
  colorSample[2]->Visible = false;
  colorSample[3]->Visible = false;

  left = 296;
  top = 24;
  for (int row=0; row<=3; row++)
  {
    for (int col=0; col<=3; col++)
    {
      imgThumb[col][row] = new TImage(formMain);
      imgThumb[col][row]->Parent=formMain;
      imgThumb[col][row]->Left=left;
      imgThumb[col][row]->Top=top;
      imgThumb[col][row]->Width=48;
      imgThumb[col][row]->Height=42;
      imgThumb[col][row]->Hint = (AnsiString)IntToStr(col)+IntToStr(row);
      imgThumb[col][row]->ShowHint = true;
      imgThumb[col][row]->OnMouseDown = thumbMouseDown;
      left += 48;
      colorNo++;
    }
    top += 42;
    left = 296;
  }

  for (int x=0; x<=3; x++)
    for (int y=0; y<=3; y++)
    {
      actThumb.x=x;
      actThumb.y=y;
      multiColor[x][y] = false;
      setThumbColors();
      for (int col=0; col<=23; col++)
        for (int row=0; row<=21; row++)
          setThumbPixel(col, row, 0, actThumb.x, actThumb.y);
    }

  actThumb.x=0;
  actThumb.y=0;
}
//---------------------------------------------------------------------------

void __fastcall TformMain::drawGridDrawCell(TObject *Sender, int Col, int Row,
      TRect &Rect, TGridDrawState State)
{
  if (chkMultiColor->Checked == false) // Single color session
  {
    if (pixelColor[Col][Row] == 0)
    {
      drawGrid->Canvas->Brush->Color = colorSample[0]->Brush->Color;
      setThumbPixel(Col, Row, 0, actThumb.x, actThumb.y);
    }
    if (pixelColor[Col][Row] == 1)
    {
      drawGrid->Canvas->Brush->Color = colorSample[1]->Brush->Color;
      setThumbPixel(Col, Row, 1, actThumb.x, actThumb.y);
    }
  }
  else
  { // Multicolor session
    int colorBit1 = pixelColor[Col*2][Row];
    int colorBit0 = pixelColor[Col*2 + 1][Row];

    if ((colorBit1 == 0) && (colorBit0 == 0))
    {
      drawGrid->Canvas->Brush->Color = colorSample[0]->Brush->Color;
      setThumbPixel(2*Col, Row, 0, actThumb.x, actThumb.y);
      setThumbPixel(2*Col+1, Row, 0, actThumb.x, actThumb.y);
    }
    if ((colorBit1 == 0) && (colorBit0 == 1))
    {
      drawGrid->Canvas->Brush->Color = colorSample[1]->Brush->Color;
      setThumbPixel(2*Col, Row, 1, actThumb.x, actThumb.y);
      setThumbPixel(2*Col+1, Row, 1, actThumb.x, actThumb.y);
    }
    if ((colorBit1 == 1) && (colorBit0 == 0))
    {
      drawGrid->Canvas->Brush->Color = colorSample[2]->Brush->Color;
      setThumbPixel(2*Col, Row, 2, actThumb.x, actThumb.y);
      setThumbPixel(2*Col+1, Row, 2, actThumb.x, actThumb.y);
    }
    if ((colorBit1 == 1) && (colorBit0 == 1))
    {
      drawGrid->Canvas->Brush->Color = colorSample[3]->Brush->Color;
      setThumbPixel(2*Col, Row, 3, actThumb.x, actThumb.y);
      setThumbPixel(2*Col+1, Row, 3, actThumb.x, actThumb.y);
    }
  }

  TRect NewRect = drawGrid->CellRect(Col, Row);
  drawGrid->Canvas->FillRect(NewRect);
}
//---------------------------------------------------------------------------
void __fastcall TformMain::drawGridMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  if (!Button == mbLeft)
    return;

  mouseLeftButton = true;
  modified = true;
  statusBar->SimpleText = "Modified";

// Make undoBuffer

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
      undoBuffer[col][row] = pixelColor[col][row];

  if (chkMultiColor->Checked == false) // Single color session
  {
    if (colorSample[0]->Pen->Width == 5)
    {
      pixelColor[drawGrid->Col][drawGrid->Row] = 0;
      thumbBuffer[actThumb.x*24+drawGrid->Col][actThumb.y*21+drawGrid->Row] = 0;
    }
    if (colorSample[1]->Pen->Width == 5)
    {
      pixelColor[drawGrid->Col][drawGrid->Row] = 1;
      thumbBuffer[actThumb.x*24+drawGrid->Col][actThumb.y*21+drawGrid->Row] = 1;
    }
  }
  else // colorSample<0,1,2,3> colors allowed
  {
    int colorBit1;
    int colorBit0;
    if (colorSample[0]->Pen->Width == 5)
    {
      colorBit1 = 0;
      colorBit0 = 0;
    }
    if (colorSample[1]->Pen->Width == 5)
    {
      colorBit1 = 0;
      colorBit0 = 1;
    }
    if (colorSample[2]->Pen->Width == 5)
    {
      colorBit1 = 1;
      colorBit0 = 0;
    }
    if (colorSample[3]->Pen->Width == 5)
    {
      colorBit1 = 1;
      colorBit0 = 1;
    }
    pixelColor[drawGrid->Col * 2][drawGrid->Row] = colorBit1;
    pixelColor[drawGrid->Col * 2 +1][drawGrid->Row] = colorBit0;
    thumbBuffer[actThumb.x*24+drawGrid->Col*2][actThumb.y*21+drawGrid->Row]=colorBit1;
    thumbBuffer[actThumb.x*24+drawGrid->Col*2+1][actThumb.y*21+drawGrid->Row]=colorBit0;
  }
}
//---------------------------------------------------------------------------


void __fastcall TformMain::drawGridMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
  if (!Shift.Contains(ssLeft))
    return;
  if (mouseLeftButton == false)
    return;

  if (chkMultiColor->Checked == false) // Single color session
  {
    if (colorSample[0]->Pen->Width == 5)
    {
      pixelColor[drawGrid->Col][drawGrid->Row] = 0;
      thumbBuffer[actThumb.x*-24+drawGrid->Col][actThumb.y*21+drawGrid->Row] = 0;
    }
    if (colorSample[1]->Pen->Width == 5)
    {
      pixelColor[drawGrid->Col][drawGrid->Row] = 1;
      thumbBuffer[actThumb.x*24+drawGrid->Col][actThumb.y*21+drawGrid->Row] = 1;
    }
}
  else // colorSample<0,1,2,3> colors allowed
  {
    int colorBit1;
    int colorBit0;
    if (colorSample[0]->Pen->Width == 5)
    {
      colorBit1 = 0;
      colorBit0 = 0;
    }
    if (colorSample[1]->Pen->Width == 5)
    {
      colorBit1 = 0;
      colorBit0 = 1;
    }
    if (colorSample[2]->Pen->Width == 5)
    {
      colorBit1 = 1;
      colorBit0 = 0;
    }
    if (colorSample[3]->Pen->Width == 5)
    {
      colorBit1 = 1;
      colorBit0 = 1;
    }
    pixelColor[drawGrid->Col * 2][drawGrid->Row] = colorBit1;
    pixelColor[drawGrid->Col * 2 +1][drawGrid->Row] = colorBit0;
    thumbBuffer[actThumb.x*24+drawGrid->Col*2][actThumb.y*21+drawGrid->Row]=colorBit1;
    thumbBuffer[actThumb.x*24+drawGrid->Col*2+1][actThumb.y*21+drawGrid->Row]=colorBit0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TformMain::itemNewClick(TObject *Sender)
{
  if (modified)
    switch (MessageDlg("Save changes?", mtConfirmation,
                       TMsgDlgButtons() << mbYes << mbNo << mbCancel, 0))
    {
      case mrYes:
      {
        itemSave->Click();
        break;
      }
      case mrNo:
      {
        break;
      }
      case mrCancel:
      {
        return;
      }
    }

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
      pixelColor[col][row] = 0;

  for (int col=0; col<=4*24-1; col++)
    for (int row=0; row<=4*21-1; row++)
      thumbBuffer[col][row] = 0;

  for (int col=0; col<=3; col++)
    colorSample[col]->Brush->Color = commColor[col];

  for (int x=0; x<=3; x++)
    for (int y=0; y<=3; y++)
    {
      actThumb.x=x;
      actThumb.y=y;
      multiColor[x][y] = false;
      setThumbColors();
      for (int col=0; col<=23; col++)
        for (int row=0; row<=21; row++)
          setThumbPixel(col, row, 0, x, y);
    }

  actThumb.x=0;
  actThumb.y=0;

  chkGrid->Checked = true;
  chkMultiColor->Checked = false;
  lastFile = "";
  drawGrid->Refresh();

  formMain->Caption = titleText;
  formMain->Caption = formMain->Caption + " - Untitled";
  modified = false;
  statusBar->SimpleText = "";
}
//---------------------------------------------------------------------------
void __fastcall TformMain::chkMultiColorClick(TObject *Sender)
{
  colorSample[2]->Visible = !(colorSample[2]->Visible);
  colorSample[3]->Visible = !(colorSample[3]->Visible);
  multiColor[actThumb.x][actThumb.y] = chkMultiColor->Checked;

  if (chkMultiColor->Checked == true)
  {
     drawGrid->ColCount /= 2;
     drawGrid->DefaultColWidth = drawGrid->DefaultColWidth * 2;
     if (chkGrid->Checked == true)
       drawGrid->DefaultColWidth++;
  }
  else
  {
    drawGrid->ColCount *= 2;
    drawGrid->DefaultColWidth /= 2;
    colorSample[lastColor]->Pen->Width=1;
    colorSample[1]->Pen->Width=5;
    lastColor = 1;
  }
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------
void __fastcall TformMain::colorPalMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  TShape* shape = dynamic_cast<TShape *>(Sender);

  for (int col=0; col<=3; col++)
  {
    if (colorSample[col]->Pen->Width == 5)
    colorSample[col]->Brush->Color = shape->Brush->Color;
  }

  setThumbColors();
  drawGrid->Refresh();
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------
void __fastcall TformMain::chkGridClick(TObject *Sender)
{
  if (drawGrid->GridLineWidth == 1)
  {
    drawGrid->GridLineWidth = 0;
    drawGrid->DefaultColWidth++;
    drawGrid->DefaultRowHeight++;
  }
  else
  {
    drawGrid->GridLineWidth = 1;
    drawGrid->DefaultColWidth--;
    drawGrid->DefaultRowHeight--;
  }
  drawGrid->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TformMain::itemExitClick(TObject *Sender)
{
  if (modified)
    switch (MessageDlg("Save changes?", mtConfirmation,
                       TMsgDlgButtons() << mbYes << mbNo << mbCancel, 0))
    {
      case mrYes:
      {
        itemSave->Click();
        Application->Terminate();
        break;
      }
      case mrNo:
      {
        Application->Terminate();
        break;
      }
    }
  else
    Application->Terminate();
}
//---------------------------------------------------------------------------


void __fastcall TformMain::itemSaveAsClick(TObject *Sender)
{
  struct ThumbFile saveBuffer;
  FILE *fileHD;

  saveDialog->Filter = "Thumbnail (*.thb)|*.thb|All files (*.*)|*.*|";
  saveDialog->DefaultExt = String("thb");
  saveDialog->Options << ofOverwritePrompt;
  if (saveDialog->Execute())
  {
    fileHD = fopen(saveDialog->FileName.c_str(), "wb");
    if (!fileHD)
    {
      ShowMessage("Couldn't create file!");
      return;
    }
  }
  else
    return;

  for (int col=0; col<=4*24-1; col++)
    for (int row=0; row<=4*21-1; row++)
      saveBuffer.pixelColor[col][row] = thumbBuffer[col][row];

  strcpy(saveBuffer.idString, "THUMB");
  saveBuffer.grid = chkGrid->Checked;

  for (int x=0; x<=3; x++)
    for (int y=0; y<=3; y++)
      for (int col=0; col<=3; col++)
      {
        saveBuffer.thumb[x][y].color[col] = thumbColor[x][y].color[col];
        saveBuffer.thumbMultiColor[x][y] = multiColor[x][y];
      }

  if (!fwrite(&saveBuffer, sizeof(saveBuffer), 1, fileHD))
    ShowMessage("Error saving file!");

  fclose(fileHD);
  lastFile = saveDialog->FileName;
  formMain->Caption = titleText;
  formMain->Caption = formMain->Caption + " - " + lastFile;
  modified = false;
  statusBar->SimpleText = "";
}
//---------------------------------------------------------------------------
void __fastcall TformMain::itemOpenClick(TObject *Sender)
{
  FILE *fileHD;
  struct ThumbFile loadBuffer;

  if (modified)
    switch (MessageDlg("Save changes?", mtConfirmation,
                       TMsgDlgButtons() << mbYes << mbNo << mbCancel, 0))
    {
      case mrYes:
      {
        itemSave->Click();
        break;
      }
      case mrNo:
      {
        break;
      }
      case mrCancel:
      {
        return;
      }
    }

  openDialog->Filter = "Thumbnail (*.thb)|*.thb|All files (*.*)|*.*|";
  if (openDialog->Execute())
  {
    fileHD = fopen(openDialog->FileName.c_str(), "rb");
    if (!fileHD)
    {
      ShowMessage("Couldn't open file!");
      return;
    }
  }
  else
    return;

  if (!fread(&loadBuffer, sizeof(loadBuffer), 1, fileHD))
  {
    ShowMessage("Error reading file!");
    fclose(fileHD);
    return;
  }

  if (strcmp(loadBuffer.idString, "THUMB"))
  {
    ShowMessage("This is not a thumbnail file!");
    fclose(fileHD);
    return;
  }

  for (int col=0; col<=4*24-1; col++)
    for (int row=0; row<=4*21-1; row++)
      thumbBuffer[col][row] =
          loadBuffer.pixelColor[col][row];

  for (int x=0; x<=3; x++)
    for (int y=0; y<=3; y++)
      for (int col=0; col<=3; col++)
      {
        thumbColor[x][y].color[col] = loadBuffer.thumb[x][y].color[col];
        multiColor[x][y] = loadBuffer.thumbMultiColor[x][y];
      }

  actThumb.x = 0;
  actThumb.y = 0;
  for (int col=0; col<=3; col++)
    colorSample[col]->Brush->Color =
                     loadBuffer.thumb[0][0].color[col];

  for (int col=0; col<=23; col++)
    for (int row=0; row<=21; row++)
      pixelColor[col][row] = loadBuffer.pixelColor[col][row];


  for (int x=0; x<=3; x++)
    for (int y=0; y<=3; y++)
      for (int col=0; col<=23; col++)
        for (int row=0; row<=21; row++)
        {
          if (multiColor[x][y] == false)
          { // Single color session
            if (thumbBuffer[x*24+col][y*21+row] == 0)
              setThumbPixel(col, row, 0, x, y);
            if (thumbBuffer[x*24+col][y*21+row] == 1)
              setThumbPixel(col, row, 1, x, y);
          }
          else
          { // Multicolor session
            int colorBit1 = thumbBuffer[x*24+col*2][y*21+row];
            int colorBit0 = thumbBuffer[x*24+col*2+1][y*21+row];

            if ((colorBit1 == 0) && (colorBit0 == 0))
            {
              setThumbPixel(2*col, row, 0, x, y);
              setThumbPixel(2*col+1, row, 0, x, y);
            }
            if ((colorBit1 == 0) && (colorBit0 == 1))
            {
              setThumbPixel(2*col, row, 1, x, y);
              setThumbPixel(2*col+1, row, 1, x, y);
            }
            if ((colorBit1 == 1) && (colorBit0 == 0))
            {
              setThumbPixel(2*col, row, 2, x, y);
              setThumbPixel(2*col+1, row, 2, x, y);
            }
            if ((colorBit1 == 1) && (colorBit0 == 1))
            {
              setThumbPixel(2*col, row, 3, x, y);
              setThumbPixel(2*col+1, row, 3, x, y);
            }
          } // End multicolor
        }

  chkMultiColor->Checked = loadBuffer.thumbMultiColor[0][0];
  chkGrid->Checked = loadBuffer.grid;

  fclose(fileHD);
  setThumbColors();
  drawGrid->Refresh();
  lastFile = openDialog->FileName;
  formMain->Caption = titleText;
  formMain->Caption = formMain->Caption + " - " + lastFile;
  modified = false;
  statusBar->SimpleText = "";
}
//---------------------------------------------------------------------------

void __fastcall TformMain::itemSaveClick(TObject *Sender)
{
  struct ThumbFile saveBuffer;
  FILE *fileHD;

  if (lastFile == "")
  {
    itemSaveAs->Click();
    return;
  }

  fileHD = fopen(lastFile.c_str(), "wb");
  if (!fileHD)
  {
    ShowMessage("Couldn't create file!");
    return;
  }

  for (int col=0; col<=4*24-1; col++)
    for (int row=0; row<=4*21-1; row++)
      saveBuffer.pixelColor[col][row] = thumbBuffer[col][row];

  strcpy(saveBuffer.idString, "THUMB");
  saveBuffer.grid = chkGrid->Checked;

  for (int x=0; x<=3; x++)
    for (int y=0; y<=3; y++)
      for (int col=0; col<=3; col++)
      {
        saveBuffer.thumb[x][y].color[col] = thumbColor[x][y].color[col];
        saveBuffer.thumbMultiColor[x][y] = multiColor[x][y];
      }

  if (!fwrite(&saveBuffer, sizeof(saveBuffer), 1, fileHD))
    ShowMessage("Error saving file!");

  fclose(fileHD);
  modified = false;
  statusBar->SimpleText = "";
}
//---------------------------------------------------------------------------
void __fastcall TformMain::drawGridMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  mouseLeftButton = false;
}
//---------------------------------------------------------------------------
void __fastcall TformMain::colorSampleMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  TShape* shape = dynamic_cast<TShape *>(Sender);

  colorSample[lastColor]->Pen->Width = 1;  // deselect last
  shape->Pen->Width=5;                          // select clicked

  for (int col=0; col<=3; col++)
    if (colorSample[col]->Pen->Width == 5)
      lastColor = col;
}
//---------------------------------------------------------------------------
void __fastcall TformMain::saveRawSprite()
{
// Create new file

  FILE *fileHD;
  saveDialog->Filter = "Sprite (*.raw)|*.raw|All files (*.*)|*.*|";
  saveDialog->DefaultExt = String("raw");
  saveDialog->Options << ofOverwritePrompt;
  if (saveDialog->Execute())
  {
    fileHD = fopen(saveDialog->FileName.c_str(), "wb");
    if (!fileHD)
    {
      ShowMessage("Couldn't create file!");
      return;
    }
  }
  else
    return;

// Generate databytes and save them to file

  for (int row=0; row<=20; row++)
    for (int col=0; col<=23; col += 8)
    {
      Byte dataByte = 0;
      Byte locValue = 128;
      for (int offset = 0; offset <=7; offset++)
      {
        if (pixelColorTemp[col+offset][row] == true)
          dataByte += locValue;
        locValue /= (Byte)2;
      }
      if (!fwrite(&dataByte, sizeof(dataByte), 1, fileHD))
      {
        ShowMessage("Error saving file!");
        fclose(fileHD);
        return;
      }
    }
  fclose(fileHD);
}
//---------------------------------------------------------------------------
void __fastcall TformMain::exportRawSpriteClick(TObject *Sender)
{
// Create tmp. sprite

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
      pixelColorTemp[col][row] = pixelColor[col][row];
  saveRawSprite();
}
//---------------------------------------------------------------------------


void __fastcall TformMain::btnClearClick(TObject *Sender)
{
// Make undoBuffer

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
      undoBuffer[col][row] = pixelColor[col][row];

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
    {
      pixelColor[col][row] = 0;
      thumbBuffer[actThumb.x*24+col][actThumb.y*21+row] = 0;
    }

  drawGrid->Refresh();

}
//---------------------------------------------------------------------------

void __fastcall TformMain::btnUndoClick(TObject *Sender)
{
  bool temp;

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
    {
      temp = pixelColor[col][row];
      pixelColor[col][row] = undoBuffer[col][row];
      thumbBuffer[actThumb.x*24+col][actThumb.y*21+row] = undoBuffer[col][row];
      undoBuffer[col][row] = temp;
    }
  drawGrid->Refresh();

}
//---------------------------------------------------------------------------
void __fastcall TformMain::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  if (modified)
    switch (MessageDlg("Save changes?", mtConfirmation,
                       TMsgDlgButtons() << mbYes << mbNo << mbCancel, 0))
    {
      case mrYes:
      {
        itemSave->Click();
        break;
      }
      case mrCancel:
      {
        CanClose = false;
        break;
      }
    }
}
//---------------------------------------------------------------------------
void __fastcall TformMain::btnRightClick(TObject *Sender)
{
  if (chkMultiColor->Checked)
  {
    int colBuffer[21][2];

    for (int row=0; row<=20; row++)
    {
      colBuffer[row][0] = pixelColor[22][row];
      colBuffer[row][1] = pixelColor[23][row];
    }

    for (int col=23; col>=0; col-=2)
      for (int row=0; row<=20; row++)
      {
        pixelColor[col+2][row] = pixelColor[col][row];
        pixelColor[col+1][row] = pixelColor[col-1][row];
      }

    for (int row=0; row<=20; row++)
    {
      pixelColor[0][row] = colBuffer[row][0];
      pixelColor[1][row] = colBuffer[row][1];
    }
  }
  else
  {
    int colBuffer[21];

    for (int row=0; row<=20; row++)
      colBuffer[row] = pixelColor[23][row];

    for (int col=23; col>=0; col--)
      for (int row=0; row<=20; row++)
        pixelColor[col+1][row] = pixelColor[col][row];

    for (int row=0; row<=20; row++)
      pixelColor[0][row] = colBuffer[row];
  }
  drawGrid->Refresh();
  copyBufferToThumb();
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------

void __fastcall TformMain::btnLeftClick(TObject *Sender)
{
  if (chkMultiColor->Checked)
  {
    int colBuffer[21][2];

    for (int row=0; row<=20; row++)
    {
      colBuffer[row][0] = pixelColor[0][row];
      colBuffer[row][1] = pixelColor[1][row];
    }

    for (int col=2; col<=23; col+=2)
      for (int row=0; row<=20; row++)
      {
        pixelColor[col-1][row] = pixelColor[col+1][row];
        pixelColor[col-2][row] = pixelColor[col][row];
      }

    for (int row=0; row<=20; row++)
    {
      pixelColor[22][row] = colBuffer[row][0];
      pixelColor[23][row] = colBuffer[row][1];
    }
  }
  else
  {
    int colBuffer[21];

    for (int row=0; row<=20; row++)
      colBuffer[row] = pixelColor[0][row];

    for (int col=1; col<=23; col++)
      for (int row=0; row<=41; row++)
        pixelColor[col-1][row] = pixelColor[col][row];

    for (int row=0; row<=20; row++)
      pixelColor[23][row] = colBuffer[row];
  }
  drawGrid->Refresh();
  copyBufferToThumb();
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------

void __fastcall TformMain::btnDownClick(TObject *Sender)
{
  int rowBuffer[24];

  for (int col=0; col<=23; col++)
    rowBuffer[col] = pixelColor[col][20];

  for (int row=19; row>=0; row--)
    for (int col=0; col<=23; col++)
      pixelColor[col][row+1] = pixelColor[col][row];

  for (int col=0; col<=23; col++)
    pixelColor[col][0] = rowBuffer[col];

  drawGrid->Refresh();
  copyBufferToThumb();
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------

void __fastcall TformMain::btnUpClick(TObject *Sender)
{
  int rowBuffer[24];

  for (int col=0; col<=23; col++)
    rowBuffer[col] = pixelColor[col][0];

  for (int row=1; row<=20; row++)
    for (int col=0; col<=23; col++)
    {
      pixelColor[col][row-1] = pixelColor[col][row];
    }

  for (int col=0; col<=23; col++)
    pixelColor[col][20] = rowBuffer[col];

  drawGrid->Refresh();
  copyBufferToThumb();
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------
void __fastcall TformMain::setThumbColors()
{
  thumbColor[actThumb.x][actThumb.y].color[0] = colorSample[0]->Brush->Color;
  thumbColor[actThumb.x][actThumb.y].color[1] = colorSample[1]->Brush->Color;
  thumbColor[actThumb.x][actThumb.y].color[2] = colorSample[2]->Brush->Color;
  thumbColor[actThumb.x][actThumb.y].color[3] = colorSample[3]->Brush->Color;
}
//---------------------------------------------------------------------------
void __fastcall TformMain::thumbMouseDown(TObject *Sender,
                     TMouseButton Button, TShiftState Shift, int X, int Y)
{
  TImage *image = dynamic_cast<TImage *>(Sender);
  AnsiString tempString = image->Hint;

  actThumb.x = StrToInt(tempString.SubString(1, 1));
  actThumb.y = StrToInt(tempString.SubString(2, 1));

  colorSample[0]->Brush->Color =
                           thumbColor[actThumb.x][actThumb.y].color[0];
  colorSample[1]->Brush->Color =
                           thumbColor[actThumb.x][actThumb.y].color[1];
  colorSample[2]->Brush->Color =
                           thumbColor[actThumb.x][actThumb.y].color[2];
  colorSample[3]->Brush->Color =
                           thumbColor[actThumb.x][actThumb.y].color[3];

  chkMultiColor->Checked = multiColor[actThumb.x][actThumb.y];
  for (int x = 0; x <= 23; x ++)
    for (int y = 0; y <= 20; y ++)
      pixelColor[x][y] = thumbBuffer[actThumb.x*24+x][actThumb.y*21+y];

  drawGrid->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TformMain::LoadEditbuffer1Click(TObject *Sender)
{
  struct SpriteFile loadBuffer;
  FILE *fileHD;

  openDialog->Filter = "Sprite (*.spr)|*.spr|All files (*.*)|*.*|";
  if (openDialog->Execute())
  {
    fileHD = fopen(openDialog->FileName.c_str(), "rb");
    if (!fileHD)
    {
      ShowMessage("Couldn't open file!");
      return;
    }
  }
  else
    return;

  if (!fread(&loadBuffer, sizeof(loadBuffer), 1, fileHD))
  {
    ShowMessage("Error reading file!");
    fclose(fileHD);
    return;
  }

  if (strcmp(loadBuffer.idString, "SPRITE"))
  {
    ShowMessage("This is not a sprite file!");
    fclose(fileHD);
    return;
  }

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
    {
      pixelColor[col][row] = loadBuffer.pixelColor[col][row];
      thumbBuffer[actThumb.x*24+col][actThumb.y*21+row] = pixelColor[col][row];
    }

  for (int col=0; col<=3; col++)
    colorSample[col]->Brush->Color = loadBuffer.col[col];

  chkMultiColor->Checked = loadBuffer.multiColor;

  fclose(fileHD);
  setThumbColors();
  drawGrid->Refresh();
  modified = true;
  statusBar->SimpleText = "Modified";
}
//---------------------------------------------------------------------------

void __fastcall TformMain::SaveEditBuffer1Click(TObject *Sender)
{
  struct SpriteFile saveBuffer;

  FILE *fileHD;
  saveDialog->Filter = "Sprite (*.spr)|*.spr|All files (*.*)|*.*|";
  saveDialog->DefaultExt = String("spr");
  saveDialog->Options << ofOverwritePrompt;
  if (saveDialog->Execute())
  {
    fileHD = fopen(saveDialog->FileName.c_str(), "wb");
    if (!fileHD)
    {
      ShowMessage("Couldn't create file!");
      return;
    }
  }
  else
    return;

  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
      saveBuffer.pixelColor[col][row] = pixelColor[col][row];

  strcpy(saveBuffer.idString, "SPRITE");
  saveBuffer.multiColor = chkMultiColor->Checked;

  for (int col=0; col<=3; col++)
    saveBuffer.col[col] = colorSample[col]->Brush->Color;

  if (!fwrite(&saveBuffer, sizeof(saveBuffer), 1, fileHD))
    ShowMessage("Error saving file!");

  fclose(fileHD);
    
}
//---------------------------------------------------------------------------
void __fastcall TformMain::FormClose(TObject *Sender, TCloseAction &Action)
{
  for (int col=0; col<=3; col++)
    delete colorSample[col];

  for (int row=0; row<=3; row++)
    for (int col=0; col<=3; col++)
      delete imgThumb[col][row];
}
//---------------------------------------------------------------------------
void __fastcall TformMain::copyBufferToThumb()
{
  for (int col=0; col<=23; col++)
    for (int row=0; row<=20; row++)
      thumbBuffer[actThumb.x*24+col][actThumb.y*21+row] = pixelColor[col][row];

}
//---------------------------------------------------------------------------
void __fastcall TformMain::setThumbPixel(int x, int y, int colIndex,
                                         int thumbX, int thumbY)
{
  x *= 2;
  y *= 2;

  imgThumb[thumbX][thumbY]->Canvas->Pen->Color =
                         thumbColor[thumbX][thumbY].color[colIndex];
  imgThumb[thumbX][thumbY]->Canvas->Rectangle(x, y, x+2, y+2);
}

void __fastcall TformMain::About1Click(TObject *Sender)
{
  formAboutBox->Left = formMain->Left+(formMain->Width-formAboutBox->Width)/2;
  formAboutBox->Top = formMain->Top+(formMain->Height-formAboutBox->Height)/2;
  formAboutBox->lbl1->Caption = titleText;
  formAboutBox->ShowModal();
}
//---------------------------------------------------------------------------

